#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################
#                                                       #
#  Primary AVSMaker Professional site generation        #
#  script, to be run through telnet, web-based          #
#  administrative interface or crontab.                 #
#                                                       #
#  Please read the documentation included with this     #
#  scriptset for full information                       #
#                                                       #
#  Usage:                                               #
#       ./avspro.pl -h      # for help                  #
#                                                       #
#########################################################













#----------------------! do not edit below this line !-----------------------


BEGIN { open (STDERR, ">>&STDOUT") }

# Modules
use Socket;
use strict;
use vars qw[%cf %mysql %used $db @cats];
$| = 1;
foreach ("routines", "substapts") {
	eval { require ("$_.pl") };
	die "Could not include $_.pl, check datapath setup in avspro.pl ($@)"
		if $@;
}

require "routines.pl" or err("Could not include routines.pl, check that file exists and permissions are correct");
require "substapts.pl" or err("Could not include substapts.pl");

foreach ("Getopt::Std", "Net::FTP") {
	(my $path = $_) =~ s/::/\//g;
	eval { require "$path.pm" };
	if (!$@) {
		import $_;
	} else {
		err("Could not find module $_! Install this [as root] by doing \"perl -MCPAN -e 'install $_\" at the command line.")
	}
}

my (
	%def,
	%AVS,
	%avs_accts,
	@avsinfo,
);

readconf();
err("No data detected, please register this program first")
	if !$cf{email};
getinput();
prt("Initialising AVSMaker Pro Edition\n");
v("Connected to MySQL server.\n");

init_all();
foreach (1..$cf{count}) {
	undef %used; undef @avsinfo;
	v("Creating site #$_\n") if ($cf{count} > 1);
	$cf{cat} = $def{cat} || $cats[rand(@cats)];
	init_site();

	unless ($cf{test}) {
		v("Initialising modules...\n");
		foreach (grep { ${$AVS{$_}}{reqinit} } keys %AVS) {
			no strict;
			v(" - init: ${$AVS{$_}}{name} [${_}]\n");
			$avs_accts{$_} = &{"init_$_"}($avs_accts{$_});
			if (!$avs_accts{$_}) {
				wrn("Could not log into AVS ${$AVS{$_}}{name}, please ensure login information is correct");
				delete $AVS{$_};
			}
		}
	}
	err("No AVSs logged into successfully, execution terminating")
		if (scalar keys %AVS <= 0 and !$cf{test});
	foreach (keys %AVS) {
		makesite($_);
	}

	if (!(scalar @avsinfo) && !$cf{test}) {
		dosql(qq[insert into ap_testsites values("$cf{basepath}/$cf{dir}")]);
		err("This site was not submitted successfully to any AVSs, execution will terminate");
	}

	my $mainurl = "http://$cf{baseurl}/$cf{dir}/".
		${$avsinfo[rand(@avsinfo)]}[2] . "/";
	open (F, "> $cf{basepath}/$cf{dir}/index.$cf{htmlext}")
		or err("Could not write to $cf{basepath}/$cf{dir}/index.$cf{htmlext}");
	print F qq[<META HTTP-EQUIV="REFRESH"; CONTENT="0; URL=$mainurl">\n];
	close F;

	my $n = -1;
	unless ($cf{test}) {
		dosql(qq[insert into ap_sites values("", now(), ].
			join("", map { qq["$cf{$_}", ] } qw(sitename cat descr)).
			'"' . join(" ", @{$cf{keywords}}) . '", '.
			join("", map { qq["$cf{$_}", ] } qw(domain dir memarea htmlext)).
			scalar(@avsinfo) . qq[, ] .
			join(", ", map { $n++; map { qq["${$avsinfo[$n]}[$_]"] } 0..3 } 1..8).
		qq[)]);
	}
	my $insid = (dosql(qq[select last_insert_id()])->fetchrow_array)[0];
	if ($cf{gls}) {
		linksite("$cf{cat}", "", "$cf{basepath}/$cf{dir}/links.$cf{htmlext}", "$cf{baseurl}/$cf{dir}/links.$cf{htmlext}", $insid);
		dosql(qq[insert into ap_linksites values("", "$cf{sitename}", "$cf{basepath}/$cf{dir}/links.$cf{htmlext}", "$cf{baseurl}/$cf{dir}/links.$cf{htmlext}", "$cf{cat}", "")]);
		se_sub("$cf{baseurl}/$cf{dir}/links.$cf{htmlext}");
		prt(" - Submitting linksite to search engines\n");
	}
	if ($cf{freehost}) {
		upload($cf{basepath}/$cf{dir});
		qx(rm -fr $cf{basepath}/$cf{dir});
	}
	prt("\n");
}
prt("Site generation completed successfully!\n");
prt(".\n") if $cf{web};

#----------------------------------! subs !----------------------------------



sub	getinput {
	my %o;
	getopts("urahnqvw123456789s:c:m:gfxk:t:d:l:", \%o);
	# opts:
	#  -h   - help
	#  -u	- update script only
	#  -r	- refresh image queue only
	#  -a   - regenerate central hub
	#  -n	- test mode
	#  -q	- quiet mode
	#  -v	- verbose mode
	#  -s,#	- number of sites to generate
	#  -c	- niche
	#  -m	- cs list of modules
	#  -g	- generate linksite
	#  -w	- run from web

	#  -f   - use freehost (overrides default)
	#  -x   - do not use freehost (overrides default)

	#  -k   - list of keywords to use
	#  -t   - site title
	#  -d   - description
	#  -l   - layout

	usage()			if $o{h};
	$cf{test}++		if $o{n};

	$cf{quiet}++	 	if $o{q};
	$cf{verbose}++		if $o{v};
	wrn("Cannot be both verbose and quiet, ignoring both"), delete @cf{"quiet", "verbose"} if ($cf{verbose} && $cf{quiet});
	$cf{web}++		if $o{w};

	getupdates(), exit	if $o{u};
	refreshimgq(), exit	if $o{r};
	regeneratehub(), exit	if $o{a};
	$cf{gls}++		if $o{g};
	
	$cf{usefreehosts} = 1	if $o{f};
	$cf{usefreehosts} = 0	if $o{x};

	foreach (1..9) {
		if ($o{$_}) {
			if ($cf{count}) {
				err("Multiple site counts specified, or count is over 9");
			} else {
				$cf{count} = $_;
			}
		}
	}
	$cf{count} ||= $o{s};
	$cf{count} ||= 1;
	err("Invalid site creation count: $cf{count}")
		if ($cf{count} =~ /\D/ || $cf{count} < 1 || $cf{count} > 20);
	
	my @avs = split(/\,/, $o{m}) if $o{m};
	foreach (@avs) {
		my $ac = dosql(qq[select name, dir, dlimit, catspersub, reqinit from ap_avs where id="$_"]);
		err("Invalid module: $_") if !$ac->rows;
		$AVS{$_} = $ac->fetchrow_hashref;
	}

	if ($o{c}) {
		$def{cat} = $o{c};
		my $ac = dosql(qq[select * from ap_cats where name="$def{cat}"]);
		err("No such category: $def{cat}") if !$ac->rows;
	}
	$def{keywords} = [ split(/[\s,;]+/, $o{k}) ] if $o{k};
	$def{sitename} = $o{t};
	$def{descr} = $o{d};
	$def{layout} = $o{l};
	foreach ("keywords", "sitename", "descr") {
		err("Cannot specify $_ when creating multiple sites")
			if $def{$_} && $cf{count} > 1;
	}
	usage()	if @ARGV;
}

sub	err {
	my $err = shift;
	wrn ($err, "ERROR");
	prt(".\n") if $cf{web};
	exit;
}

sub	wrn {
	my $err	= shift(@_)."\n";
	my $warn = shift(@_) || "WARNING";
	$err	=~ s/((.{1,70})(\s+))(?!\n)/$2\n    /g;		# wordwrap
	$err	=~ s/\n(?!    )/\n    /g;			# indent
	$err 	=~ s/\s+$//;
	print "\n$warn:\n  * $err\n\n";		# report despite -q 
}

sub	init_all {
	# load avs modules from ./modules/
	if (keys(%AVS) == 0) {
		my $ac = dosql(qq[select id, name, dir, dlimit, catspersub, reqinit from ap_avs where enabled=1]);
		while (my $line = $ac->fetchrow_hashref) {
			$AVS{$$line{id}} = $line;
		}
	}
	foreach my $avs (keys %AVS) {
		prt(" - Using AVS module: ${$AVS{$avs}}{name}\n");
		eval { require("modules/avs/${$AVS{$avs}}{name}.pm") };
		err("Could not open module ${$AVS{$avs}}{name}.pm; check that it is present ".
			"in modules/avs/ ($@)") if $@;
		my $mname = "${$AVS{$avs}}{name}";
		import $mname;
	}
	err(	"No modules found!\n\n".
		"Please enable at least one AVS")
		if (keys(%AVS) == 0);

	foreach ("pnmscale", "djpeg", "cjpeg") {
		my ($path) = $cf{$_} =~ /^(\S+)/;
		err("Could not find program $_!") if !-x $path;
	}
}


sub	init_site {
	undef %avs_accts;
	v("Selecting AVS accounts\n");
	foreach my $avs (keys %AVS) {
		if (my $href = randline("avs_accounts", qq[where avs = "$avs" and enabled = 1 and (cday is null or cday != curdate() or subs <= ${$AVS{$avs}}{dlimit})])) {
			$avs_accts{$avs} = [ $$href{acct}, $$href{pass}, $$href{realid}, $$href{id} ];
			v(" - ${$AVS{$avs}}{name}: $$href{acct}\n");
		} else {
			wrn("No valid accounts available for AVS ${$AVS{$avs}}{name}, or submission limit has been reached; AVS has been disabled");
			delete $AVS{$avs};
		}
	}
	err("No AVS accounts to submit to, add more accounts or enable another AVS")
		if (keys %AVS == 0);
	prt("Setting up vars\n");
	prt(" - Category: $cf{cat}\n");
	# grab random site title
	$cf{sitename} = $def{sitename}
		|| randline("sitenames", qq[where cat = "$cf{cat}" or cat = ""], "name")
		or err("No site names for niche $cf{cat} found, please add more");
	v(" - Site name: $cf{sitename}");

	if ($cf{remsitenames} && !$cf{test}) {
		dosql(qq[delete from ap_sitenames where name="$cf{sitename}" and cat="$cf{cat}"]);
		v(" [deleted from list]\n");
	} else {
		v("\n");
	}
	
	# get random header
	$cf{header} = randline("headers", qq[where cat = "$cf{cat}" or cat = ""], "text")
		or err("No headers for niche $cf{cat} found, please add more");
	if ($cf{remheaders} && !$cf{test}) {
		dosql(qq[delete from ap_headers where text="$cf{header}" and cat="$cf{cat}"]);
	}

	# get description
	$cf{descr} = $def{descr}
		|| randline("descr", qq[where cats regexp "$cf{cat}" or cats = ""], "text")
		or err("No descriptions for niche $cf{cat} found, please add more");
	if ($cf{remdescrs} && !$cf{test}) {
		dosql(qq[delete from ap_descr where text="$cf{descr}" and cat="$cf{cat}"]);
	}

	# get random keywords
	if ($def{keywords}) {
		$cf{keywords} = $def{keywords};
	} else {
		my $n = 0;
		my @keywords;
		while ($n < ($cf{numkeywords})) {
			my $query = qq[where (cats regexp "$cf{cat}" or cats = "") ].
				join("", map { qq[ and word != "$_"] } @keywords);
			my $keyword = randline("keywords", $query, "word")
				or err("Not enough keywords found in keyword database for niche $cf{cat}, please add more");
			push (@keywords, $keyword);
			$n++;
		}
		$cf{keywords} = [ @keywords ];
	}
	v(" - Keywords: @{$cf{keywords}}\n");
		
	# get random domain
	if ($cf{usefreehosts} && dosql(qq[select id from ap_freehosts where enabled=1 limit 1])->rows) {
		$cf{freehost} =	\%{randline("freehosts", qq[where enabled = 1])};
		prt(" - Using freehost: ${$cf{freehost}}{name}, account ${$cf{freehost}}{user}\n");
		$cf{domain} = $cf{baseurl} = "${$cf{freehost}}{rooturl}";
		$cf{basepath} = "$cf{tmppath}/$$.".time();
	} else {
	 	my $href	= randline("domains", qq[where cats regexp "$cf{cat}" or cats = ""])
	 		or err("No domains found for niche $cf{cat}, please add.");
	 	$cf{domain}  = $cf{baseurl} = $$href{domain};
		$cf{basepath} = $$href{dir};	
	}

	if (!-d $cf{basepath}) {
		mkdir_r ($cf{basepath}, $cf{dirperms}) || err("Could not make base directory $cf{basepath}");
	}
	my $dirtries = 0;	
	my $dir = randline("dirs", qq[where cats regexp "$cf{cat}" or cats = ""], "dir")
		or err("No directories found for niche $cf{cat}, please add");
	my $ext = randline("direxts", "", "ext")
		or err("No directory extensions found for niche $cf{cat}, please add");
	while (-e "$cf{basepath}/$dir$ext" && $dirtries++ < 10) {
		$dir = randline("dirs", qq[where cats regexp "$cf{cat}" or cats = ""], "dir");
		my $exttries = 0;
		while (-e "$cf{basepath}/$dir$ext" && $exttries++ < 10) {
			$ext = randline("direxts", "", "ext");
		}
	}
	err("Not enough directories/extensions, please add more")
		if $dirtries > 10;
	$cf{dir} = "$dir$ext";

	mkdir_r ("$cf{basepath}/$cf{dir}", $cf{dirperms})
		or err("Could not make base directory: $cf{basepath}/$cf{dir}");
	v(" - URL selected: http://$cf{baseurl}/$cf{dir}\n");

	dosql(qq[insert into ap_testsites values("$cf{basepath}/$cf{dir}")]) if $cf{test};

	$cf{memarea} = randline("memarea", "", "dir");
	$cf{htmlext} = randline("htmlext", "", "ext")
		or err("No HTML extensions found");

	$cf{ua} = randline("useragents", "", "ua")
		or err("No user agents found");

	if ($cf{uselogogen}) {
		my $ac = dosql(qq[select * from ap_logogen limit 1]);
		if ($ac->rows) {
			v(" - No logo image selected, autogenerator will be used on a per-site basis\n");
			$cf{persitelogo} = 1;
		} else {
			v(" - Logo image generating...\n");
			$cf{persitelogo} = 0;
			$cf{logo} = genlogo();
		}
	} else {
		$cf{logo} = "$cf{imagepath}/$cf{cat}/logo/".randfile("$cf{imagepath}/$cf{cat}/logo");
		wrn("No logo images found! Upload to $cf{imagepath}/$cf{cat}/logo/"), delete $cf{logo}
			if ($cf{logo} =~ /\/$/);
		v(" - Logo: $cf{logo}\n") if $cf{logo};
	}
	
	# get default sponsor
	my $href	= randline("sponsors", qq[where cats regexp "$cf{cat}" or cats=""]);
	$cf{sponsor}	= $$href{id};
	v(" - Default sponsor: $$href{name} [$cf{sponsor}]\n");
}

sub	makesite {
	my $avs = shift;
	delete @cf{
		"avsdir", 
		"layout",
		"scheme",
		"bodytag",
		"tabletag",
		"tdtag",
		"fonttag",
		"tour",
		"cont",
	};

	# select HTML layout
	prt("Creating site [version: ${$AVS{$avs}}{name}]\n");
	$cf{avsdir} = (dosql(qq[select dir from ap_avs where id="$avs"])->fetchrow_array)[0]
		or err("No directory specified for AVS ${$AVS{$avs}}{name}?");
	mkdir_r("$cf{basepath}/$cf{dir}/$cf{avsdir}/images", $cf{dirperms})
		or err("Could not create AVS directory, basepath $cf{basepath}/$cf{dir}");
	mkdir_r("$cf{basepath}/$cf{dir}/$cf{avsdir}/$cf{memarea}/images", $cf{dirperms})
		or err("Could not create content directory, basepath $cf{basepath}/$cf{dir}");

	if ($def{layout}) {
		$cf{layout} = $def{layout};
	} else {
		$cf{layout} = randline("layouts",
			qq[where (cats regexp "$cf{cat}" or cats = "") and (avss regexp "$avs" or avss = "")], "name")
			or err("No suitable site layouts found, category $cf{cat}, AVS $avs; please add.");
	}
	my $href = dosql(qq[select * from ap_layouts where name="$cf{layout}"])->fetchrow_hashref;
	v(" - HTML layout: $cf{layout}\n");
	$cf{scheme} = $$href{scheme};

	if ($cf{persitelogo}) {
		v(" - Generating logo image...\n");
		my $ac = dosql(qq[select * from ap_logogen where scheme="$cf{scheme}"]);
		if ($ac->rows) {
			my $row = $ac->fetchrow_hashref;
			$cf{logo} = genlogo(@$row{"scheme", "fg", "bg"});
		} else {
			$cf{logo} = genlogo();
		}
	}

	foreach my $n (1..6) {
		if ($$href{"tour$n"}) {
			$cf{tour}[$n] = $$href{"tour$n"};
			v("   - Tour page $n: $cf{tour}[$n]\n");
		}
	}
	foreach my $n (1..15) {
		if ($$href{"cont$n"}) {
			$cf{cont}[$n] = $$href{"cont$n"};
			v("   - Content page $n: $cf{cont}[$n]\n");
		}
	}
	
	initscheme($cf{cat});
	v(" - HTML scheme: $cf{scheme}\n");

	foreach (1..3) {
		$cf{"custtag$_"} = randline("custtag$_", qq[where scheme="$cf{scheme}" or scheme=""], "tag");
	}

	prt(" - Generating tour pages [total: $#{$cf{tour}}]...\n");

	my $n;
	for ($n = 1; $n <= ($#{$cf{tour}} + 1); $n++) {
		next if !${$cf{tour}}[$n];
		my $imagetype = ${$cf{tour}}[$n];
		my $prev_matches = scalar(grep { /^$imagetype$/ } @{$cf{tour}}[1..$n]);
		my $pname = ($n > 1 ? $imagetype : "index") .
			($prev_matches < 2 ? "" : $prev_matches);
		open (X, "> $cf{basepath}/$cf{dir}/$cf{avsdir}/$pname.$cf{htmlext}")
			or err("Could not open HTML for write");
		print X parsetmpl(${$cf{tour}}[$n], $n, $avs, "tour");
		close X;
		$cf{entrypage} = $pname if $n == $#{$cf{tour}};
	}
	prt(" - Generating content pages [total: $#{$cf{cont}}]...\n");
	for ($n = 1; $n <= ($#{$cf{cont}} + 1); $n++) {
		next if !${$cf{cont}}[$n];
		my $imagetype = ${$cf{cont}}[$n];
		my $prev_matches = scalar(grep { /^$imagetype$/ } @{$cf{cont}}[1..$n]);
		my $pname = ($n > 1 ? $imagetype : "index") .
			($prev_matches < 2 ? "" : $prev_matches);
		open (X, "> $cf{basepath}/$cf{dir}/$cf{avsdir}/$cf{memarea}/$pname.$cf{htmlext}")
			or err("Could not open content area HTML for write");
		print X parsetmpl(${$cf{cont}}[$n], $n, $avs, "cont");
		close X;
	}
	if ($cf{usehtaccess} && -e "$cf{datapath}/data/htaccess") {
		open (I, "< $cf{datapath}/data/htaccess");
		open (O, "> $cf{basepath}/$cf{dir}/$cf{avsdir}/$cf{memarea}/.htaccess")
			or err("Could not write to .htaccess?");
		while (<I>) {
			s!%dir%!$cf{basepath}/$cf{memarea}!gi;
			s!%url%!http://$cf{baseurl}/$cf{memarea}!gi;
			s!%htmlext%!$cf{htmlext}!gi;
			print O;
		}
		close I;
		close O;
	}
	# submit 
	if ($cf{freehost}) {
		v(" - Uploading to freehost...\n");
		upload("$cf{basepath}/$cf{dir}/$cf{avsdir}", $cf{avsdir});
		qx(rm -fr $cf{basepath}/$cf{dir}/$cf{avsdir});
	}
	my $completeurl = "http://$cf{baseurl}/$cf{dir}/$cf{avsdir}";
	prt(qq[ - DONE: $completeurl ($completeurl/$cf{memarea}/)\n]);

	if (!$cf{test}) {
		no strict;
		v(" - Submitting to AVS ${$AVS{$avs}}{name}...\n");
		if (defined (my $siteid = &{"submit_$avs"}($avs_accts{$avs}, getavscats($avs)))) {
			prt(" - Submitted successfully to ${$AVS{$avs}}{name}, site ID $siteid\n");
			open (F, "< $cf{basepath}/$cf{dir}/$cf{avsdir}/$cf{entrypage}.$cf{htmlext}")
				or err("Could not open entry page HTML to write site ID");
			my $html;
			while (<F>) {
				s/%siteid%/$siteid/gi;
				s/%userid%/${$avs_accts{$avs}}[0]/gi;
				s/%sitetitle%/$cf{sitename}/gi;
				$html .= $_;
			}
			close F;

			open (F, "> $cf{basepath}/$cf{dir}/$cf{avsdir}/$cf{entrypage}.$cf{htmlext}");
			print F $html;
			close F;

			push(@avsinfo, [ $avs, ${$avs_accts{$avs}}[3], $cf{avsdir}, $siteid ]);
		} else {
			wrn(qq[Submission to AVS ${$AVS{$avs}}{name} failed!]);
			# Check your account information is correct, and if so, report this problem to AVSMakerPro.com.]);
		}
	} else {
		push(@avsinfo, [ $avs, ${$avs_accts{$avs}}[3], $cf{avsdir}, "" ]);
	}
}

sub	initscheme {
	my $cat = shift;
	$cf{scheme} ||=	randline("schemes", qq[where cats regexp "$cat" or cats = ""], "name")
		or err("No suitable schemes found for niche $cat, please add");
	foreach ("body", "table", "td", "font") {
		$cf{"${_}tag"} = randline("${_}tags", qq[where scheme="$cf{scheme}"], "tag")
		or err("No $_ tags for scheme $cf{scheme} found, please add.");
	}
}

sub	getavscats {
	my $avs = shift;
	my $ac = dosql(qq[select * from ap_avs_catmap where avs="$avs" and cat="$cf{cat}"]);
	my @ccodes;	# [ "catname", "catcode", "flag=value" ]
	if ($ac->rows) {
		my $row = $ac->fetchrow_hashref;
		foreach (1..${$AVS{$avs}}{catspersub}) {
			if ($$row{"code_$_"}) {
				$ccodes[$_] = [ $$row{"code_$_"}, $$row{"value_$_"} ];
			} else {
				last;
			}
		}
	}
	foreach my $n (1..(${$AVS{$avs}}{catspersub})) {
		if (!$ccodes[$n]) {
			my $query = qq[where avs="$avs"];
			$query .= qq[ and fvalue="${$ccodes[1]}[1]"] if $n > 1;
			$query .= ($n > 1 ? join("", map { qq[ and not (code = "${$ccodes[$_]}[0]" and fvalue = "${$ccodes[$_]}[1]")] } 1..($n - 1)) : "");
			my $line = randline("avs_cats", $query)
				or err("Not enough category codes..?");
			$ccodes[$n] = [ $$line{code}, $$line{fvalue} ];
		}
	}
	return @ccodes;
}

sub	parsetmpl {
	# same name, different subroutine
	my ($page, $pnum, $avs, $sec) = @_;
	my ($path, $html);
	
	foreach ("$cf{datapath}/templates/$avs/$page", "$cf{datapath}/templates/default/$page") {
		($html, $path) = readrandtmpl($_);
		last if $path;
	}
	err("No suitable templates found (pagetype $page, AVS ${$AVS{$avs}}{name}); upload to $cf{datapath}/templates/$avs/$page or $cf{datapath}/templates/default/$page")
		if !$path;
	
	$html = substapts($html, $path, $avs, $sec, $pnum);
	return $html;
}

sub	upload {
	my ($upload_dir, $subdir) = @_;
	err("Directory does not exist: $upload_dir") if !-d $upload_dir;
	my %data = %{$cf{freehost}};
	my $ftp = Net::FTP->new("$data{host}:$data{port}")
		or err("Could not create FTP connection?");
	$ftp->login($data{user}, $data{pass})
		or err("Could not login to freesite $data{name}, bad login: $data{user}");
	$ftp->cwd($data{rootdir})
		or err("Could not change directory to $data{rootdir} on freehost $data{name}");
	$ftp->mkdir($cf{dir})
		or err("Could not make directory $cf{dir} on freehost $data{name}");
	$ftp->cwd($cf{dir});
	if ($subdir) {
		$ftp->mkdir($subdir)
			or err("Could not make directory $subdir on freehost $data{name}");
		$ftp->cwd($subdir);
	}
	v(" - Uploading files to freehost $data{name}...\n");
	r_upload($ftp, $upload_dir);
	$ftp->quit;
}

sub	r_upload {
	my ($ftp, $dir) = @_;
	opendir(D, "$dir") or err("Could not open directory $dir");
	my @items = grep { !/^\./ } readdir D;
	closedir D;
	foreach my $item (@items) {
		if (-d "$dir/$item") {
			$ftp->mkdir($item);
			$ftp->cwd($item);
			r_upload($ftp, "$dir/$item");
		} else {
			$ftp->put("$dir/$item", $item);
		}
	}
	$ftp->cwd("..");
}

sub	regeneratehub {
	prt("Hub site recreation initialising...\n");
	my $row = (dosql(qq[select * from ap_linksites where id=1]))->fetchrow_hashref;
	my ($file, $dir, $url);
	if ($$row{path} =~ /\w+\.\w+$/ || -f $$row{path}) {
		$file = $$row{path};
		($dir = $file) =~ s/\/[^\/]+$//;
	}
	else {
		$dir = $$row{path};
		$file = $$row{path} . ($$row{path} =~ m!/$! ? "" : "/") . "index.html";
	}
	if ($$row{url} =~ /\w+\.\w+$/) {
		($url = $$row{url}) =~ s/\/[^\/]+$//;
	}
	else {
		$url = $$row{url};
	}
#	(my $dir = $$row{path}) =~ s/\/[^\/]+$//;
#	(my $url = $$row{url}) =~ s/\/[^\/]+$//;
	mkdir_r($dir);
	$cf{sitename} = $$row{name};
	foreach (@cats) {
		$cf{nichelinks} .= qq[<a href="$_.html">$_</a><br>\n]
	}
	initscheme($cats[rand(@cats)]);
	open (N, "> $file") or err("Could not write to hub HTML (path $file)");
	print N substapts(readrandtmpl("$cf{datapath}/templates/linksites/hub"));
	close N;
	v(" - Index page done\n");
	foreach (@cats) {
		linksite($_, "", "$dir/$_.html", "$url/$_.html");
	}
	prt(" - Submitting to search engines.\n");
	se_sub($url);
	prt("DONE: http://$$row{url}\n");
}

sub	linksite {
	# incid = id of site that must be included in links
	my ($cat, $avs, $path, $url, $incid) = @_;
	v(" - Generating niche link site, category $cat\n");
	$cf{scheme} = "";
	initscheme($cat);
	my $query = qq[where cat="$cat"];
	$query .= qq[ and (].
		join(" or ", map { qq[avs${_}_id = "$avs"] } 1..8).
		qq[)] if $avs;
	$cf{sitelinks} = "";
	foreach my $n (1..$cf{numlinks}) {
		my $site = randline("sites", $query)
			or last;
		$query .= qq[ and id != $$site{id}];
		my $avsn;
		if ($avs) {
			foreach (1..8) {
				$avsn = $_, last
					if $$site{"avs${_}_id"} eq $avs;
			}
		} else {
			$avsn = int(rand($$site{numavss}) + 1);
		}
		my $avsdir = $$site{"avs${avsn}_dir"}
			or err("Could not find AVS dir, ID $$site{id}?");
		$cf{sitelinks} .= qq[<a href="http://$$site{domain}/$$site{dir}/$avsdir/">$$site{sitename}</a><br>\n];
	}
	open (N, "> $path")
		or err("Could not write to linksite path $path");
	$cf{cat} = $cat;
	print N substapts((readrandtmpl("$cf{datapath}/templates/linksites/niche")), $avs);
	close N;
	prt(" - Niche link site completed, URL http://$url\n");
}

sub	se_sub {
	$cf{url} = "http://" . shift(@_);
	my $ac = dosql(qq[select id, name from ap_se where enabled=1]);
	while (my $row = $ac->fetchrow_hashref) {
		v("   - Submitting to $$row{name}... ");
		my $sdat = (dosql(qq[select * from ap_se_fields where se="$$row{id}"])->fetchrow_hashref);
		my $params = $$sdat{params};
		foreach ("url", "sitename", "descr", "name", "email", "pass") {
			next if !$$sdat{$_};
			my $data = "$$sdat{$_}=$cf{$_}";
			$params = ($params ? "$params&$data" : "$data");
		}
		my $html = gethttp({
			host	=> "$$sdat{host}",
			file	=> "$$sdat{cgi}",
			params	=> "$params",
			pat	=> "($$sdat{matchstr})",
		});
		if ($html eq "$$sdat{matchstr}") {
			v("success!\n");
		} else {
			v("failed.\n");
		}
	}
}

sub	getupdates {
	my ($updates, $headers) = gethttp({
		host	=> "perlcoders.com",
		file	=> "/apupdates/getupdates.cgi",
		params	=> "$cf{lastupdateid}",
		auth	=> "$cf{email}:$cf{pcpass}",
	});
	err(qq[Could not get updates; re-enter your PerlCoders password (the first admin password set)].
		qq[ inside the general configuration page, or e-mail our support team and we'll reset your].
		qq[ updater password.]) if $headers !~ /^HTTP\/\d\.\d 200/;
	$updates = substr($updates, 1);
	v("Script is up-to-date, v$cf{version}\n"), return if !$updates;
	my $count = 0;
	foreach (split(/\0/, $updates)) {
		$count++;
		my ($id, $type, $params, $content) = split(/\n/, $_, 4);
		$cf{lastupdateid} = $id;
		if ($type eq "file") {
			if ($params =~ /\.(pl|cgi)$/) {
				study $content;
				open (F, "< $0");
				($cf{perl} = <F>) =~ s/\#\!(.+)\n/$1/;
				close F;
				foreach ("host", "port", "db", "user", "pass") {
					$content =~ s/%mysql$_%/$mysql{$_}/g;
				}
				foreach ("datapath", "perl", "tmppath", "dirperms") {
					$content =~ s/%$_%/$cf{$_}/g;
				}
			}
			open (F, ">$cf{datapath}/$params") or next;
			print F $content;
			close F;
		}
		elsif ($type eq "sql") {
			foreach (grep { /\w/ } split(/[\n\r]+/, $content)) {
				dosql($_);
			}
		}
		elsif ($type eq "cmd") {
			foreach (grep { /\w/ } split(/[\n\r]+/, $content)) {
				qx($_);
			}
		}
	}
	$cf{version} = sprintf("1.%03d", $cf{lastupdateid});
	dosql(qq[update ap_data set lastupdateid=$cf{lastupdateid}]);
	prt("Applied $count updates, current version $cf{version}\n");
}

sub	randdir {
	my ($dir, $type) = @_;
	opendir (F, "$dir") or return;
	my @dirs = grep { !/^\./ && -d "$dir/$_" } readdir(F);
	if (defined $type) {
		foreach (@{$used{$type}}) {
			@dirs = grep { !/^\Q$_\E$/ } @dirs;
		}
	}
	closedir F;

	return $dirs[rand(@dirs)] || undef;
}

sub	qre {
	# No longer used!
#	$_[0] =~ /^\/(.+)\/([imsx]+)/ ?
#		"(?$2-".join("", map { $2 !~ /$_/ and $_ } qw(i x s m)).":$1)"
#		: $2;
	1;
}

sub	refreshimgq {
	err("Bad image root directory: $cf{imagepath}") if !-d $cf{imagepath};
	my $ac = dosql(qq[select name from ap_imagetypes]);
	my @types = ("content");
	push(@types, $_) while $_ = ($ac->fetchrow_array)[0];
	foreach my $cat (@cats) {
		v("Could not open niche directory $cf{imagepath}/$cat\n"), next
			unless -d "$cf{imagepath}/$cat";
		foreach my $type (@types) {
			my @imgs;
			v("Could not open niche directory $cf{imagepath}/$cat/$type\n"), next
				unless opendir(D, "$cf{imagepath}/$cat/$type");
			foreach (grep { !/^\.*$/ && -f "$cf{imagepath}/$cat/$type/$_" } readdir D) {
				push (@imgs, $_);
			}
			closedir D;
			next if ($#imgs + 1) ==
				(dosql(qq[select count(*) from ap_images where cat="$cat" and ].
				qq[type="$type"])->fetchrow_array)[0];
			prt("Adding new images, category $cat, type $type...\n");
			dosql(qq[delete from ap_images where cat="$cat" and type="$type"]);
			if (@imgs > 10000) {
				# too many pictures break mysql!
				foreach my $tk (1..(int(scalar(@imgs) / 10000) + 1)) {
					my $from = ($tk - 1) * 10000;
					my $to = $tk * 10000 - 1;
					$to = $#imgs if $to >= $#imgs;
					dosql(qq[insert into ap_images values].
						join(", ", (map { qq[("$cat", "$type", "$_", 1)] } grep { /\w/ } @imgs[$from..$to])));
				}
			} else {
				dosql(qq[insert into ap_images values].
					join(", ", (map { qq[("$cat", "$type", "$_", 1)] } @imgs)));
			}
		}
		my @sets;
		v("Could not open photoset directory $cf{imagepath}/$cat/sets\n"), next
			unless opendir(D, "$cf{imagepath}/$cat/sets");
		foreach (grep { !/^\.*$/ && -d "$cf{imagepath}/$cat/sets/$_" } readdir D) {
			push(@sets, $_);
		}
		closedir D;
		next if ($#sets + 1) ==
			(dosql(qq[select count(*) from ap_imagesets where cat="$cat"])->fetchrow_array)[0];
		prt("Adding new photosets, category $cat...\n");
		dosql(qq[delete from ap_imagesets where cat="$cat"]);
		dosql(qq[insert into ap_imagesets values].
			join(", ", (map { qq[("$cat", "$_", 1)] } @sets)));
	}
	v("All done.\n");
}

sub	usage {
	my $out;
	print (($out = <<"	EOT") =~ tr/\t//d ? $out : undef);
	Usage:
	  $0 [-huranqvs#scmgfdktdl]
	    -h   - help
	    -u   - update script only
	    -r   - refresh image queue only
	    -a   - regenerate central hub

	    -n   - test mode
	    -q   - quiet mode
	    -v   - verbose mode

	    -s,# - number of sites to generate
	    -c   - niche
	    -m   - comma-separated list of AVS codes so submit to
	    -g   - generate linksite
	    -f   - use freehost (overrides default)
	    -x   - do not use freehost (overrides default)
	    -k   - list of keywords to use
	    -t   - site title
	    -d   - description
	    -l   - layout
	EOT
	exit;
}

sub	prt {
	print shift if !$cf{quiet};
}

sub	v {
	print shift if $cf{verbose};
}

sub	getlogo {
	my ($scheme, $fg, $bg) = @_;
	my %c;
	
	my %types = (
		"alien-glow"	=> [ qw(colorGlow) ],
		"blended"	=> [ qw(colorBackground colorText colorStart colorEnd) ],
		"bovinated"	=> [ ],
		"carved"	=> [ qw(Background toggleRaise) ],
		"chrome"	=> [ qw(colorText colorBackground) ],
#		"sota-chrome"	=> [ qw(colorHighlight colorChrome Factor Saturation Lightness) ],
		"cool-metal"	=> [ qw(colorBackground toggleSeascape) ],
		"crystal"	=> [ qw(Background Chrome) ],
#		"glowing"	=> [ qw(colorBackground) ],
		"neon"		=> [ qw(colorBackground colorGlow toggleShadow) ],
		"starscape"	=> [ qw(colorGlow) ],
		"basic2"	=> [ qw(colorBackground colorText) ],
		"starburst"	=> [ qw(colorBurst colorBackground) ],
		"textured"	=> [ qw(colorBackground colorStart colorEnd) ],
	);

	if ($fg || $bg) {
		%c = (
			f => [ map { hex($_) } ($fg =~ /([a-f0-9]{2})/gi) ],
			b => [ map { hex($_) } ($bg =~ /([a-f0-9]{2})/gi) ],
		);
		delete @types{"bovinated", "crystal"};
	}

	my %items = (
		colorGlow	=> "RGB",
		colorBackground	=> "RGB",
		colorStart	=> "RGB",
		colorEnd	=> "RGB",
		colorBurst	=> "RGB",
		colorHighlight	=> "RGB",
		colorChrome	=> "RGB",
		colorText	=> "RGB",
		toggleRaise	=> "Bool",
		toggleShadow	=> "Bool",
		toggleSeascape	=> "Bool",
		Background	=> "Tex",
		Factor		=> "Var",
		Saturation	=> "Var",
		Lightness	=> "Var",
		Chrome		=> "Var",	
	);

	my %fbs = (
		glow		=> "f",
		background	=> "b",
		start		=> "b",
		end		=> "b",
		burst		=> "f",
		highlight	=> "f",
		chrome		=> "f",
		text		=> "f",
	);

	my @fonts = qw(
		agate
		alfreddrake
		apollo
		baskerville
		becker
		blippo
		bodidly
		bodoni
		capri
		charter
		comicscartoon
		cooper
		cracklingfire
		crillee
		cuneifontlight
		dragonwick
		engraver
		frizquadrata
		futura_poster
		romeo
		roostheavy
		tribeca
		victoriassecret
	);

	my @textures = qw (
		2stucco.gif
		canvas.jpg
		paper.gif
		texture1.jpg
		texture2.jpg
		texture3.jpg
	);

	my $type = (keys %types)[int rand(keys %types)];
	my $font = $fonts[int rand(@fonts)];
	my $fontsize = int(rand(12)) + 34;

	my $text = $cf{sitename};
	my $bits = sprintf("%d", length($text) / 20);
	foreach my $n (1..$bits) {
		my $end = ((18 + $n) * $n);
		$text =~ s/^((.{1,$end})(\s+))/$2%0a/;
	}
	$text =~ s/%0a(\w+)$/ $1/;

	my $params	 = "cgiscript=./logo_gen/net-fu_dynam.cgi" .
			"&script=${type}-logo" .
			"&text=$text" .
			"&fontname=${font}" .
			"&fontsize=$fontsize";
	foreach my $item (@{$types{$type}}) {
		my $it = $items{$item};
		if ($it eq "RGB") {
			if ($fg || $bg) {
				my $fog = $fbs{lc(($item =~ /[a-z]+([A-Z][a-z]+)$/)[0])};
				foreach (0..2) {
					my $val = ${$c{$fog}}[$_];
					$val += (int(rand(21)) - 10);
					$val = 255 if $val > 255;
					$val = 0 if $val < 0;
					$params .= "&" . $item . ("R", "G", "B")[$_] . "=$val";
				}
			} else {
				foreach ("R", "G", "B") {
					$params .= "&${item}${_}=" . int(rand(256));
				}
			}
		}
		elsif ($it eq "Bool") {
			$params	.= "&${item}=" . int(rand(2));
		}
		elsif ($it eq "Tex") {
			$params .= "&${item}=http://www.avsmakerpro.com/textures/" . $textures[int(rand(@textures))];
		}
		elsif ($it eq "Var") {
			if ($item eq "Chrome" || $item eq "Factor") {
				$params .= "&valuestart${item}=2&valueend${item}=20&valuestep${item}=1&value${item}=" . (int(rand(19)) + 2);
			}
			else {
				$params .= "&valuestart${item}=-100&valueend${item}=100valuestep${item}=10&value${item}=" . ((int(rand(21)) - 10) * 10);
			}
		}
	}

	return gethttp({
		host	=> "www.avsmakerpro.com",
		file	=> "/logo/proxy_form.cgi",
		method	=> "get",
		params	=> $params,
	});
}

sub	genlogo {
	my ($graphic, $attempts);
	while ((!$graphic or $graphic =~ /Incorrect results/) && $attempts <= 3) {
		$graphic = getlogo(@_);
		$attempts++;
	}
	err("Could not generate logo image, please contact support")
		if $graphic =~/Incorrect results/ && $attempts >= 3;

	my $scheme = shift(@_);
	(my $localname = ($cf{sitename} . ($scheme ? "-$scheme" : "") . "-$$.jpg")) =~ s/[^\w.-]//g;

	mkdir_r("$cf{imagepath}/logo_gen") if !-d "$cf{imagepath}/logo_gen";

	open (F, "> $cf{imagepath}/logo_gen/$localname")
		or err("Could not write to logo image $cf{imagepath}/logo_gen/$localname, check permissions");
	print F $graphic;
	close F;
	v(" - Logo image generated successfully\n");
	return "$cf{imagepath}/logo_gen/$localname";
}
